local t =	Def.ActorFrame {};
local customx = 0 --The x offset of the orbs.

t[#t+1] = Def.ActorFrame{
	--InitCommand=cmd(x,THEME:GetMetric("StepsDisplayListRow","ItemsSpacingY"));
	CurrentSongChangedMessageCommand=function(self)
		self:visible(GAMESTATE:GetCurrentSong() ~= nil);
	end;
	Def.Sprite{
		Texture="_icon";
		InitCommand=cmd(zoom,0.55;animate,false);
		SetMessageCommand=function(self,param)
			if param.StepsType then
				--short for "short string".
				--TODO: Using localization values for this is absurd, remove it
				local sString = THEME:GetString("StepsDisplay StepsType",ToEnumShortString(param.StepsType));
				if sString == "Single" then
					if param.Steps:GetDescription() == "DANGER!" then
						self:setstate(4);
					else
						self:setstate(0);
					end
				elseif sString == "Double" then
					self:setstate(1);
				elseif sString == "SinglePerformance" or sString == "Half-Double" then
					self:setstate(2);
				elseif sString == "DoublePerformance" or sString == "Routine" then
					self:setstate(3);
				else
					self:setstate(5);
				end;
			end;
		end;
	};
	LoadFont("monsterrat/_montserrat semi bold 60px")..{
		InitCommand=cmd(zoom,.45;skewx,-0.15;y,0.5);
		SetMessageCommand=function(self,param)
			local meter = param.Meter;
			if meter >= 99 then
				self:settext("??");
			else
				--Format with 2 integers, so 6 -> 06
				self:settextf("%02d",meter);
			end;
		end;
	};

	-- NEW LABEL
	Def.Sprite{
		Texture="new";
		InitCommand=cmd(zoom,0.4;y,-17);
		SetMessageCommand=function(self,param)
			local scorelist = PROFILEMAN:GetMachineProfile():GetHighScoreList(GAMESTATE:GetCurrentSong(),param.Steps);
			--If the number of high scores is less than one, this chart is new.
			self:visible(#scorelist:GetHighScores() < 1);
		end;
	};

	-- DANGER LABEL
	Def.Sprite{
		Texture="danger";
		InitCommand=cmd(zoom,0.4;y,18);
		OnCommand=cmd(diffuseshift; effectoffset,1; effectperiod, 0.5; effectcolor1, 1,1,0,1; effectcolor2, 1,1,1,1;);
		SetMessageCommand=function(self,param)
			self:visible(param.Steps:GetDescription() == "DANGER!");
		end;
	};
	
	-- DESC LABEL	
	--[[LoadFont("common normal")..{
		Text="";
		InitCommand=cmd(zoom,0.4; maxwidth,120;skewx,-0.05;y,22);
		SetMessageCommand=function(self,param)

			local descrp = param.Steps:GetDescription();
			--Check for "DANGER!" before checking blacklist
			if descrp == "DANGER!" then
				self:settext("");
			else
				self:settext(descrp);
			end
			
		end;
	};]]

};



return t
